#include <bits/stdc++.h>

#define mp make_pair
#define pb push_back
#define all(x) (x).begin(),(x).end()
#define in(x) int x=nxt()

using namespace std;

inline int nxt() {
    int n;
    scanf("%d", &n);
    return n;
}

typedef pair <int, int> PII;
typedef long long ll;
typedef unsigned long long ull;
typedef int itn;
typedef long double ld;

using namespace std;

struct edge {
    int from;
    int to;
    int u;
    int f;
};

const int M = 10000;
const int N = 1000;
edge e[M + M];
vector <int> g[N];
int q[N];

int sz = 0;

void addEdge (int a, int b) {
    edge A = edge{a, b, 1, 0};
    edge B = edge{b, a, 0, 0};
    g[a].pb(sz);
    e[sz++] = A;
    g[b].pb(sz);
    e[sz++] = B;
}

int p[N];
char used[N];
int n, m;

bool bfs(int s, int t) {
    memset(used, 0, n * sizeof(char));
    int q1 = 0, q2 = 0;
    q[q1++] = s;
    used[s] = 1;
    while (q1 != q2) {
        int v = q[q2++];
        if (v == t) {
            return true;
        }
        for (int E : g[v]) {
            edge & ee = e[E];
            if (ee.f != ee.u && !used[ee.to]) {
                q[q1++] = ee.to;
                p[ee.to] = E;
                used[ee.to] = 1;
            }
        }
    }
    return false;
}

void relax(int s, int t) {
    for (int cur = t; cur != s; cur = e[p[cur]].from) {
        int E = p[cur];
        e[E].f++;
        e[E ^ 1].f--;
    }
}

void solve() {
    n = nxt(), m = nxt();
    if (!n) exit(0);
    int s = nxt() - 1;
    int t = nxt() - 1;
    for (int i = 0; i < n; ++i) {
        g[i].clear();
    }
    sz = 0;
    for (int i = 0; i < m; ++i) {
        int a = nxt() - 1;
        int b = nxt() - 1;
        addEdge(a, b);
    }
    int flow = 0;
    while (bfs(s, t)) {
        ++flow;
        relax(s, t);
    }
    int cnt = 0;
    for (int i = 0; i < m; ++i) {
        edge & e1 = e[i + i];
        edge & e2 = e[i + i + 1];
        if (e1.f != e1.u) {
            e1.u = 0;
            e2.u = 1;
            if (bfs(s, t)) {
                ++cnt;
            }
            e1.u = 1;
            e2.u = 0;
        }
    }
    flow += (cnt != 0);
    cout << flow << " " << cnt << "\n";
}

int main()
{
#ifdef LOCAL
    freopen("input.txt", "r", stdin);
#endif // LOCAL
    while (1)
        solve();
    return 0;
}
